#include "HCNetSDK.h"
#include <iostream>
#include <fstream>
#include <cstring>

int main(int argc, const char** argv) {
    if (argc < 4)
    {
        std::cerr << "usage: " << argv[0] << " <ip> <username> <password> [<channel1-path> [<channel2-path> ...]]" << std::endl;
	return -1;
    }
    NET_DVR_Init();

    NET_DVR_USER_LOGIN_INFO loginInfo = {0};
    NET_DVR_DEVICEINFO_V40 deviceInfo = {0};

    strcpy(loginInfo.sDeviceAddress, argv[1]);
    strcpy(loginInfo.sUserName, argv[2]);
    strcpy(loginInfo.sPassword, argv[3]);
    loginInfo.wPort = 8000;
    loginInfo.bUseAsynLogin = 0;

    LONG userID = NET_DVR_Login_V40(&loginInfo, &deviceInfo);
    if (userID < 0) {
        std::cerr << "Login failed: " << NET_DVR_GetLastError() << std::endl;
        return 1;
    }

    NET_DVR_JPEGPARA jpegPara = {0};
    jpegPara.wPicSize = 2;      // Max resolution
    jpegPara.wPicQuality = 2;   // High quality

    const DWORD bufferSize = 4 * 1024 * 1024; // 4MB buffer
    char* jpegBuffer = new char[bufferSize];

    for (int channel = 1; channel <= argc - 4; ++channel) {
        DWORD jpegSize = 0;

        bool success = NET_DVR_CaptureJPEGPicture_NEW(
            userID,
            channel,
            &jpegPara,
            jpegBuffer,
            bufferSize,
            &jpegSize
        );

        if (success && jpegSize > 0) {
	  std::string filename = argv[3 + channel];
            std::ofstream out(filename, std::ios::binary);
            out.write(jpegBuffer, jpegSize);
            out.close();
            std::cout << "Channel " << channel << ": saved to " << filename << " (" << jpegSize << " bytes)\n";
        } else {
            std::cerr << "Channel " << channel << ": capture failed. Error: " << NET_DVR_GetLastError() << std::endl;
        }
    }

    delete[] jpegBuffer;
    NET_DVR_Logout(userID);
    NET_DVR_Cleanup();
    return 0;
}
