#include "HCNetSDK.h"
#include <iostream>
#include <cstring>

int main(int argc, const char** argv) {
    if (argc != 4)
    {
        std::cerr << "usage: " << argv[0] << " <ip> <username> <password>" << std::endl;
	return -1;
    }
    NET_DVR_Init();

    NET_DVR_USER_LOGIN_INFO loginInfo = {0};
    NET_DVR_DEVICEINFO_V40 deviceInfo = {0};

    // Set IP, username, and password
    strcpy(loginInfo.sDeviceAddress, argv[1]);
    strcpy(loginInfo.sUserName, argv[2]);
    strcpy(loginInfo.sPassword, argv[3]);
    loginInfo.wPort = 8000;
    loginInfo.bUseAsynLogin = 0;

    LONG lUserID = NET_DVR_Login_V40(&loginInfo, &deviceInfo);
    if (lUserID < 0) {
        std::cerr << "Login failed. Error: " << NET_DVR_GetLastError() << std::endl;
        return -1;
    } else {
       std::cout << "Login successful." << std::endl;
    }

    if (!NET_DVR_RebootDVR(lUserID)) {
        std::cerr << "Reboot failed. Error: " << NET_DVR_GetLastError() << std::endl;
    } else {
        std::cout << "Camera rebooted successfully." << std::endl;
    }

    NET_DVR_Logout(lUserID);
    NET_DVR_Cleanup();
    return 0;
}
