#!/bin/bash

set -e

BINARY=./reboot
LIB_DIR=./lib
COM_DIR=./lib/HCNetSDKCom
TEMP_LOG=tmp_strace.log

echo "🔍 Checking runtime and dynamic .so usage for: $BINARY"
echo

# Step 1: Check direct dependencies via ldd
echo "📦 Direct dependencies via ldd:"
ldd $BINARY | grep "=> $LIB_DIR" | awk '{print $1, $3}' | tee direct_deps.txt
echo

# Step 2: Check indirect dependencies (e.g., via dlopen)
echo "📡 Dynamic runtime .so access via strace:"
strace -f -e openat $BINARY 2>&1 | grep -i '\.so' | grep "$LIB_DIR" | tee $TEMP_LOG

# Clean the paths and extract filenames
grep -o "$LIB_DIR[^ \"]*" $TEMP_LOG | sort -u > runtime_deps.txt

# Step 3: Check HCNetSDKCom subdir
echo
echo "📁 Inspecting HCNetSDKCom libraries:"
find $COM_DIR -type f -name "*.so" | while read sofile; do
    if grep -q "$sofile" runtime_deps.txt; then
        echo "✅ USED: $sofile"
    else
        echo "❌ UNUSED: $sofile"
    fi
done

# Step 4: Summary
echo
echo "✅ Summary of required .so files:"
cat runtime_deps.txt | tee used_libs_summary.txt

# Cleanup
rm -f $TEMP_LOG
