__all__: list[str] = []

import cv2
import cv2.typing
import typing as _typing


# Classes
class HDF5:
    # Functions
    def close(self) -> None: ...

    def grcreate(self, grlabel: str) -> None: ...

    def hlexists(self, label: str) -> bool: ...

    def atexists(self, atlabel: str) -> bool: ...

    def atdelete(self, atlabel: str) -> None: ...

    @_typing.overload
    def atwrite(self, value: int, atlabel: str) -> None: ...
    @_typing.overload
    def atwrite(self, value: float, atlabel: str) -> None: ...
    @_typing.overload
    def atwrite(self, value: str, atlabel: str) -> None: ...
    @_typing.overload
    def atwrite(self, value: cv2.typing.MatLike, atlabel: str) -> None: ...
    @_typing.overload
    def atwrite(self, value: cv2.UMat, atlabel: str) -> None: ...

    @_typing.overload
    def atread(self, value: int, atlabel: str) -> None: ...
    @_typing.overload
    def atread(self, value: float, atlabel: str) -> None: ...
    @_typing.overload
    def atread(self, value: str, atlabel: str) -> None: ...
    @_typing.overload
    def atread(self, atlabel: str, value: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def atread(self, atlabel: str, value: cv2.UMat | None = ...) -> cv2.UMat: ...

    @_typing.overload
    def dscreate(self, rows: int, cols: int, type: int, dslabel: str) -> None: ...
    @_typing.overload
    def dscreate(self, rows: int, cols: int, type: int, dslabel: str, compresslevel: int) -> None: ...
    @_typing.overload
    def dscreate(self, rows: int, cols: int, type: int, dslabel: str, compresslevel: int, dims_chunks: _typing.Sequence[int]) -> None: ...
    @_typing.overload
    def dscreate(self, rows: int, cols: int, type: int, dslabel: str, compresslevel: int, dims_chunks: int) -> None: ...
    @_typing.overload
    def dscreate(self, n_dims: int, sizes: int, type: int, dslabel: str) -> None: ...
    @_typing.overload
    def dscreate(self, n_dims: int, sizes: int, type: int, dslabel: str, compresslevel: int) -> None: ...
    @_typing.overload
    def dscreate(self, sizes: _typing.Sequence[int], type: int, dslabel: str, compresslevel: int = ..., dims_chunks: _typing.Sequence[int] = ...) -> None: ...
    @_typing.overload
    def dscreate(self, n_dims: int, sizes: int, type: int, dslabel: str, compresslevel: int, dims_chunks: int) -> None: ...

    def dsgetsize(self, dslabel: str, dims_flag: int = ...) -> _typing.Sequence[int]: ...

    def dsgettype(self, dslabel: str) -> int: ...

    @_typing.overload
    def dswrite(self, Array: cv2.typing.MatLike, dslabel: str) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.UMat, dslabel: str) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: int) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.UMat, dslabel: str, dims_offset: int) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: _typing.Sequence[int], dims_counts: _typing.Sequence[int] = ...) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.UMat, dslabel: str, dims_offset: _typing.Sequence[int], dims_counts: _typing.Sequence[int] = ...) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: int, dims_counts: int) -> None: ...
    @_typing.overload
    def dswrite(self, Array: cv2.UMat, dslabel: str, dims_offset: int, dims_counts: int) -> None: ...

    @_typing.overload
    def dsinsert(self, Array: cv2.typing.MatLike, dslabel: str) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.UMat, dslabel: str) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: int) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.UMat, dslabel: str, dims_offset: int) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: _typing.Sequence[int], dims_counts: _typing.Sequence[int] = ...) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.UMat, dslabel: str, dims_offset: _typing.Sequence[int], dims_counts: _typing.Sequence[int] = ...) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.typing.MatLike, dslabel: str, dims_offset: int, dims_counts: int) -> None: ...
    @_typing.overload
    def dsinsert(self, Array: cv2.UMat, dslabel: str, dims_offset: int, dims_counts: int) -> None: ...

    @_typing.overload
    def dsread(self, dslabel: str, Array: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def dsread(self, dslabel: str, Array: cv2.UMat | None = ...) -> cv2.UMat: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: int, Array: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: int, Array: cv2.UMat | None = ...) -> cv2.UMat: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: _typing.Sequence[int], Array: cv2.typing.MatLike | None = ..., dims_counts: _typing.Sequence[int] = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: _typing.Sequence[int], Array: cv2.UMat | None = ..., dims_counts: _typing.Sequence[int] = ...) -> cv2.UMat: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: int, dims_counts: int, Array: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def dsread(self, dslabel: str, dims_offset: int, dims_counts: int, Array: cv2.UMat | None = ...) -> cv2.UMat: ...

    def kpgetsize(self, kplabel: str, dims_flag: int = ...) -> int: ...



# Functions
def open(HDF5Filename: str) -> HDF5: ...


